function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 55);

T = World_Economy_Competitive.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(47) = getPowerDeriv(T(7),params(2)/(params(2)-1),2);
T(48) = T(30)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(49) = getPowerDeriv(T(5),T(1),2);
T(50) = T(37)+exp(y(37))*exp(y(37))*getPowerDeriv(exp(y(37)),1-params(3),2);
T(51) = T(3)*T(50);
T(52) = T(29)+exp(y(35))*exp(y(35))*getPowerDeriv(exp(y(35)),1/params(2),2);
T(53) = getPowerDeriv(T(5),T(9),2);
T(54) = getPowerDeriv(T(18),(-params(14)),2);
T(55) = getPowerDeriv(T(16),(-params(14)),2);

end
